<?php

namespace Inside\Permission\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 *
 * @mixin Builder
 * @mixin \Eloquent
 */
class RoleCategory extends Model
{
    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_roles_categories';

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * Fillable properties
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'pid',
        'weight',
    ];

    /**
     * Get all category role's.
     *
     * @return HasMany
     */
    public function roles(): HasMany
    {
        return $this->hasMany(
            Role::class,
            'role_category_id',
            'id'
        );
    }
}
