<?php

namespace Inside\Permission\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Inside\Permission\Models\Traits\RefreshBackofficeEntriesCache;

/**
 * @mixin Builder
 * @mixin \Eloquent
 */
class Permission extends Model
{
    use RefreshBackofficeEntriesCache;

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_permissions';

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that are hidden.
     *
     * @var array
     */
    protected $hidden = [
        'id',
    ];

    /**
     * The attributes that are fillable
     *
     * @var array
     */
    protected $fillable = [
        'user_uuid',
        'role_id',
        'action',
        'uuid',
        'type',
    ];

    /**
     * Get all permissions roles.
     *
     * @return BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(
            Role::class,
            'inside_roles_permissions_schema',
            'permission_id',
            'role_id'
        );
    }

    /**
     * Get all permissions users.
     *
     * @return BelongsToMany
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(
            User::class,
            'inside_users_permissions_schema',
            'permission_id',
            'user_uuid'
        );
    }
}
