<?php

namespace Inside\Permission\Listeners;

use Inside\Content\Events\ContentDeletedEvent;
use Inside\Permission\Models\Permission;
use Inside\Permission\Models\PermissionSchema;

/**
 * Attach schema to role listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class DeletePermissionListener
{
    public function handle(ContentDeletedEvent $event): void
    {
        $model = $event->model;

        Permission::where('type', get_class($model))->where('uuid', $model->uuid)->delete();

        PermissionSchema::where('authorizable_type', get_class($model))->where('authorizable_uuid', $model->uuid)
            ->delete();
    }
}
