<?php

namespace Inside\Permission\Listeners;

use Illuminate\Support\Facades\Cache;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users as UserContent;
use Inside\Permission\Events\RoleCreatedEvent;
use Inside\Permission\Events\RoleDeletedEvent;
use Inside\Permission\Events\RoleUpdatedEvent;
use Inside\Permission\Facades\Role;

/**
 * Attach user to role listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AttachUserToRoleListener
{
    public function handle(RoleCreatedEvent|RoleUpdatedEvent|RoleDeletedEvent $event): void
    {
        $role = $event->role;

        if (! $role->is_automatic) {
            return;
        }

        $users = UserContent::all();

        foreach ($users as $userContent) {
            $user = User::findOrFail($userContent->uuid);
            Role::handleRole($role, $user, $userContent);
            Cache::forget(md5('inside.permission.'.$user->uuid.'.informations'));
            Cache::forget('inside_permission.roles.count.'.$role->id);
        }
    }
}
