<?php

namespace Inside\Permission\Listeners;

use Illuminate\Support\Facades\Cache;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\Users;
use Inside\Permission\Facades\Permission;
use Inside\Permission\Facades\Role as RoleService;
use Inside\Permission\Models\Role;

/**
 * Attach role to user listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AttachRoleToUserListener
{
    public function handle(ContentFullyInsertedEvent|ContentCreatedEvent|ContentUpdatedEvent $event): void
    {
        if (! $event->model instanceof Users) {
            return;
        }

        $user = Permission::user($event->model);

        if (! $user) {
            return;
        }

        $roles = Role::where(['is_automatic' => true])->whereNull('type')->get();

        foreach ($roles as $role) {
            RoleService::handleRole($role, $user, $event->model);
            Cache::forget('inside_permission.roles.count.'.$role->id);
        }
        Cache::forget(md5('inside.permission.'.$user->uuid.'.informations'));
    }
}
