<?php

namespace Inside\Permission\Facades;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Inside\Content\Models\Content;
use Inside\Permission\Services\PermissionSchemaService;

/**
 * PermissionSchema facade
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 * @method static void resetContentSpecificPermissionsV2(Content $content)
 * @method static bool hasContentSpecificPermissionV2(Content $content)
 * @method static Collection getContentSpecificPermissionsV2(Content $content)
 * @see PermissionSchemaService
 */
class PermissionSchema extends Facade
{
    /**
     * @inheritDoc
     */
    protected static function getFacadeAccessor()
    {
        return 'permission.schema';
    }
}
