<?php

namespace Inside\Permission\Exodus\Services\ViewIndexer;

use Illuminate\Database\Query\Builder;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Inside\Menu\Models\FooterMenuLink;
use Inside\Menu\Models\HeaderMenuLink;
use Inside\Permission\Exodus\Enums\MenuEnum;
use Inside\Permission\Exodus\Models\ViewModels\MenuIndex;

class MenuViewIndexer extends BaseViewIndexer
{
    const TABLE = MenuIndex::TABLE;

    /**
     * @return Collection<string>
     */
    public function getModels(): Collection
    {
        return collect(MenuEnum::values());
    }

    public function selectQueryBuilder(string $class): Builder
    {
        $classRaw = str($class)
            ->when(DB::getDriverName() !== 'pgsql', fn ($string) => $string->replace('\\', '\\\\'))
            ->start("'")
            ->finish("' AS type")
            ->toString();

        return DB::table($class::TABLE)->select('uuid', DB::raw($classRaw))->distinct();
    }
}
