<?php

namespace Inside\Permission\Exodus\Services\ViewIndexer;

use Illuminate\Database\Query\Builder;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Inside\Host\Exodus\Services\ContentTypeStatusService;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentTranslationIndexes;
use Inside\Permission\Exodus\Models\ViewModels\ContentTranslationIndexes;

class ContentTranslationViewIndexer extends BaseViewIndexer
{
    const TABLE = ContentTranslationIndexes::TABLE;

    /**
     * @return Collection<string>
     */
    public function getModels(): Collection
    {
        return app(ContentTypeStatusService::class)
            ->permissibles()
            ->notCategorizables()
            ->collect()
            ->whereNotIn('type', config('permission.hidden_types'))
            ->pluck('type')
            ->map(fn (string $type) => type_to_class($type));
    }

    public function selectQueryBuilder(string $class): Builder
    {
        $classRaw = str($class)
            ->when(DB::getDriverName() !== 'pgsql', fn ($string) => $string->replace('\\', '\\\\'))
            ->start("'")
            ->finish("' AS translatable_type")
            ->toString();

        return DB::table(class_to_table($class))->select('uuid_host', 'uuid AS translatable_uuid', DB::raw($classRaw));
    }
}
