<?php

namespace Inside\Permission\Exodus\Services\AccessRestriction\Traits;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Services\AccessRestriction\CapabilityAccessRestriction;

trait HasCapababilities
{
    /**
     * @return Collection<CapabilityDto>
     */
    public static function availableCapabilities(): Collection
    {
        return CapabilityAccessRestriction::availables()->filter(function (CapabilityDto $dto) {
            return in_array($dto->getName(), self::$capabilities);
        });
    }
}
