<?php

namespace Inside\Permission\Exodus\Services\AccessRestriction;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Contracts\AccessRestrictions;
use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Dto\Indexes\MenuIndexDto;
use Inside\Permission\Exodus\Dto\Privileges\MenuPrivilegeDto;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Models\ViewModels\MenuIndex;
use Inside\Permission\Exodus\Services\AccessRestriction\Traits\HasCapababilities;

final class MenuAccessRestriction extends BaseAccessRestriction implements AccessRestrictions
{
    use HasCapababilities;

    private static array $capabilities = [
        CapabilityEnum::READ,
    ];

    /**
     * @return Collection<MenuPrivilegeDto>
     */
    public static function expected(): Collection
    {
        return MenuIndex::all()
            ->crossJoin(self::availableCapabilities())
            ->map(function (array $privileges) {
                /** @var MenuIndex $index */
                /** @var CapabilityDto $capability */
                [$index, $capability] = $privileges;

                return MenuPrivilegeDto::from(
                    MenuIndexDto::fromModel($index),
                    $capability,
                );
            });
    }

    /**
     * @return Collection<MenuPrivilegeDto>
     */
    public static function availables(): Collection
    {
        return MenuPrivilege::query()->get()->collect()->map(
            fn (MenuPrivilege $privilege) => MenuPrivilegeDto::fromModel($privilege)
        );
    }
}
