<?php

namespace Inside\Permission\Exodus\Services\AccessRestriction;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Contracts\AccessRestrictions;
use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Capability;

final class CapabilityAccessRestriction extends BaseAccessRestriction implements AccessRestrictions
{
    /**
     * @return Collection<CapabilityDto>
     */
    public static function expected(): Collection
    {
        return collect(CapabilityEnum::values())->map(function (string $name) {
            return CapabilityDto::from($name);
        });
    }

    /**
     * @return Collection<CapabilityDto>
     */
    public static function availables(): Collection
    {
        return  Capability::query()->get()->collect()->map(
            fn (Capability $capability) => CapabilityDto::fromModel($capability)
        );
    }
}
