<?php

namespace Inside\Permission\Exodus\Services\AccessRestriction;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Contracts\AccessRestrictions;
use Inside\Permission\Exodus\Dto\Privileges\BackofficePrivilegeDto;
use Inside\Permission\Exodus\Enums\BackofficeEnum;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\Traits\HasCapababilities;
use Inside\Permission\Facades\Permission;

final class BackofficeAccessRestriction extends BaseAccessRestriction implements AccessRestrictions
{
    use HasCapababilities;

    private static array $capabilities = [
        CapabilityEnum::READ,
    ];

    /**
     * @return Collection<BackofficePrivilegeDto>
     */
    public static function expected(): Collection
    {
        return collect(BackofficeEnum::values())
            ->crossJoin(self::availableCapabilities())
            ->map(fn (array $privileges) => BackofficePrivilegeDto::from(...$privileges));
    }

    /**
     * @return Collection<BackofficePrivilegeDto>
     */
    public static function availables(): Collection
    {
        return BackofficePrivilege::query()->get()->collect()->map(function (BackofficePrivilege $backofficeSection) {
            return BackofficePrivilegeDto::fromModel($backofficeSection);
        });
    }
}
