<?php

namespace Inside\Permission\Exodus\Models\ViewModels;

use Illuminate\Database\Eloquent\Model;

abstract class ViewModel extends Model
{
    public $timestamps = false;

    public $incrementing = false;

    protected $fillable = [];

    public static function boot(): void
    {
        parent::boot();

        static::saving(fn ($model) => false);
        static::updating(fn ($model) => false);
        static::creating(fn ($model) => false);
        static::replicating(fn ($model) => false);
        static::deleting(fn ($model) => false);
    }
}
