<?php

namespace Inside\Permission\Exodus\Models\ViewModels;

use Illuminate\Database\Eloquent\Relations\MorphTo;
use Inside\Database\Eloquent\Builder;
use Inside\Menu\Models\MenuLink;

/**
 * @property string $uuid
 * @property string $type
 * @property MenuLink $menu
 * @mixin Builder
 */
class MenuIndex extends ViewModel
{
    const TABLE = 'exodus_menu_index';

    protected $table = self::TABLE;

    protected $primaryKey = 'uuid';

    protected $keyType = 'string';

    protected $with = [
        'menu',
    ];

    /**
     * @mixin Builder
     * @return MorphTo
     */
    public function menu(): MorphTo
    {
        return $this->morphTo('menu', 'type', 'uuid', 'uuid');
    }
}
