<?php

namespace Inside\Permission\Exodus\Models\ViewModels;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Collection;

/**
 * @property string $uuid_host
 * @property string $type
 * @property Collection<CategorizableContentTranslationIndexes> $translations
 */
final class CategorizableContentIndex extends ViewModel
{
    const TABLE = 'exodus_categorizable_content_indexes';

    protected $table = self::TABLE;

    protected $primaryKey = 'uuid_host';

    protected $keyType = 'string';

    protected $with = [
        'translations',
    ];

    public function translations(): HasMany
    {
        return $this->hasMany(CategorizableContentTranslationIndexes::class, 'uuid_host', 'uuid_host');
    }
}
