<?php

namespace Inside\Permission\Exodus\Models\Privileges;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Models\ViewModels\MenuIndex;

/**
 * @property int $id
 * @property int $capability_id
 * @property string $index_uuid
 * @property Capability $capability
 * @property ?MenuIndex $index
 * @property Collection<Role> $roles
 * @mixin Builder
 */
class MenuPrivilege extends Model
{
    const TABLE = 'exodus_menu_privileges';

    const PIVOT_ROLE_TABLE = 'exodus_menu_privilege_role';

    /**
     * The table without the timestamps.
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = self::TABLE;

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $fillable = [
        'capability_id',
        'index_uuid',
    ];

    protected $with = [
        'capability',
        'index',
    ];

    public function scopeLangcode(Builder $query, string $langcode): Builder
    {
        return $query->whereHas(
            relation: 'index',
            callback: fn (Builder $query) => $query->whereHasMorph(
                relation: 'menu',
                types: '*',
                callback: fn (Builder $query) => $query->where('langcode', $langcode)
            )
        );
    }

    /**
     * @mixin Builder
     * @return BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(
            related: Role::class,
            table: self::PIVOT_ROLE_TABLE,
            foreignPivotKey: 'menu_privilege_id',
            relatedPivotKey: 'role_id'
        )->withPivot('pivot_id');
    }

    /**
     * @mixin Builder
     * @return BelongsTo
     */
    public function index(): BelongsTo
    {
        return $this->belongsTo(MenuIndex::class, 'index_uuid', 'uuid');
    }

    /**
     * @mixin Builder
     * @return BelongsTo
     */
    public function capability(): BelongsTo
    {
        return $this->belongsTo(Capability::class, 'capability_id', 'id');
    }
}
