<?php

namespace Inside\Permission\Exodus\Models\Privileges;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Inside\Database\Eloquent\Builder;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Models\ViewModels\ContentTranslationIndexes;

/**
 * @property int $id
 * @property int $capability_id
 * @property string $uuid
 * @property Capability $capability
 * @property ContentTranslationIndexes $index
 * @property Collection<Role> $roles
 * @mixin Builder
 */
class ContentPrivilege extends Model
{
    const TABLE = 'exodus_content_privileges';

    const PIVOT_ROLE_TABLE = 'exodus_content_privilege_role';

    /**
     * The table without the timestamps.
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = self::TABLE;

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $fillable = [
        'capability_id',
        'uuid',
    ];

    protected $with = [
        'capability',
    ];

    /**
     * @mixin Builder
     * @return BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(
            related: Role::class,
            table: static::PIVOT_ROLE_TABLE,
            foreignPivotKey: 'content_privilege_id',
            relatedPivotKey: 'role_id'
        )->withPivot('pivot_id');
    }

    /**
     * @mixin Builder
     * @return BelongsTo
     */
    public function index(): BelongsTo
    {
        return $this->belongsTo(ContentTranslationIndexes::class, 'uuid', 'translatable_uuid');
    }

    /**
     * @mixin Builder
     * @return BelongsTo
     */
    public function capability(): BelongsTo
    {
        return $this->belongsTo(Capability::class, 'capability_id', 'id');
    }
}
