<?php

namespace Inside\Permission\Exodus\Listeners;

use Illuminate\Support\Facades\Log;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshContentTranslationIndexesViewTable;
use Inside\Permission\Exodus\Actions\RemoveUnnecessaries\RemoveUnnecessaryContentPrivileges;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class RemovePrivilegesOnDeletedContent
{
    public function handle(ContentDeletedEvent $event): void
    {
        /** @var Content $model */
        $model = $event->model;

        if (! $model::isPermissible() || $model::isCategorizable()) {
            return;
        }

        (new RemoveUnnecessaryContentPrivileges())->execute();
        (new RefreshContentTranslationIndexesViewTable())->execute();

        RolePrivilegesService::clearAllCache();
    }
}
