<?php

namespace Inside\Permission\Exodus\Listeners;

use Illuminate\Support\Facades\Log;
use Inside\Menu\Events\MenuDeletedEvent;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshMenuIndexesViewTable;
use Inside\Permission\Exodus\Actions\RemoveUnnecessaries\RemoveUnnecessaryMenuPrivileges;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class RemovePrivilegesOnDeleteMenu
{
    public function handle(MenuDeletedEvent $event): void
    {
        (new RemoveUnnecessaryMenuPrivileges())->execute();
        (new RefreshMenuIndexesViewTable())->execute();

        RolePrivilegesService::clearAllCache();
    }
}
