<?php

namespace Inside\Permission\Exodus\Listeners;

use Illuminate\Support\Facades\Log;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Actions\GenerateMissing\GenerateMissingContentPrivileges;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshContentTranslationIndexesViewTable;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Services\ComputeRestriction\ComputeRestrictionService;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class ComputeRoleRestrictionsOnSavedContent
{
    public function handle(ContentCreatedEvent|ContentUpdatedEvent $event): void
    {
        if (! $event->model instanceof Content) {
            return;
        }

        $model = $event->model;

        if (! $model::isPermissible()) {
            return;
        }

        Log::info('ComputeRoleRestrictionsOnSavedContent', [
            'model' => $model,
            'class' => get_class($model),
        ]);

        (new GenerateMissingContentPrivileges())->execute();
        (new RefreshContentTranslationIndexesViewTable())->execute();

        ComputeRestrictionService::computeCapabilitiesOnContentForRoles($event->model);
    }
}
