<?php

namespace Inside\Permission\Exodus\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Permission\Exodus\Actions\StorePrivileges\StoreContentTypePrivileges;
use Inside\Permission\Exodus\Actions\StorePrivileges\StoreMenuPrivileges;
use Inside\Permission\Exodus\Dto\Privileges\MenuPrivilegeDto;
use Inside\Permission\Exodus\Http\Resources\ContentTypePrivilegeCollection;
use Inside\Permission\Exodus\Http\Resources\MenuPrivilegeCollection;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class MenuAccessRestriction extends Controller
{
    public function index(Request $request, int $roleId): JsonResponse
    {
        /** @var Role $role */
        $role = Role::query()->find($roleId);

        /** @var Collection<MenuPrivilegeDto> $privileges */
        $privileges = $role->getAccessRestriction()->getMenuPrivileges();

        $inheritance = $role->name !== Role::AUTHENTICATED;

        $request->setDefaultLocale(config('app.locale'));

        return response()->json(MenuPrivilegeCollection::from($privileges, $request->getLocale(), $inheritance)->toArray());
    }

    public function store(Request $request, int $roleId): JsonResponse
    {
        /** @var Role $role */
        $role = Role::query()->find($roleId);

        (new StoreMenuPrivileges())->execute($role, $request->get('data'));

        return response()->json();
    }

    public function combined(Request $request, string $userUuid): JsonResponse
    {
        /** @var Collection<Role> $roles */
        $roles = User::find($userUuid)?->roles()->withoutDeprecatedRoles()->get();

        /** @var Collection<MenuPrivilegeDto> $privileges */
        $privileges = RolePrivilegesService::of(...$roles)->getMenuPrivileges();

        $request->setDefaultLocale(config('app.locale'));

        return response()->json([
            'data' => data_get(MenuPrivilegeCollection::from($privileges, $request->getLocale())->toArray(), 'data', []),
            'roles' => $roles->pluck('name')->toArray(),
        ]);
    }
}
