<?php

namespace Inside\Permission\Exodus\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Permission\Exodus\Actions\StorePrivileges\StoreCategorizableContentPrivileges;
use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Http\Resources\CategorizableContentPrivilegeCollection;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Services\ComputeRestriction\ComputeRestrictionService;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class CategorizableContentAccessRestriction extends Controller
{
    public function index(Request $request, int $roleId): JsonResponse
    {
        /** @var Role $role */
        $role = Role::query()->find($roleId);

        /** @var Collection<ContentPrivilegeDto> $privileges */
        $privileges = $role->getAccessRestriction()->getCategorizableContentPrivileges();

        $inheritance = $role->name !== Role::AUTHENTICATED;

        $request->setDefaultLocale(config('app.locale'));

        return response()->json(CategorizableContentPrivilegeCollection::from($privileges, $request->getLocale(), $inheritance)->toArray());
    }

    public function store(Request $request, int $roleId): JsonResponse
    {
        /** @var Role $role */
        $role = Role::query()->find($roleId);

        $role->getAccessRestriction()->clearCache('categorizable_content');

        (new StoreCategorizableContentPrivileges())->execute($role, $request->get('data'));

        return response()->json();
    }

    public function combined(Request $request, string $userUuid): JsonResponse
    {
        /** @var Collection<Role> $roles */
        $roles = User::find($userUuid)?->roles()->withoutDeprecatedRoles()->get();

        /** @var Collection<ContentPrivilegeDto> $privileges */
        $privileges = RolePrivilegesService::of(...$roles)->getCategorizableContentPrivileges();

        $request->setDefaultLocale(config('app.locale'));

        return response()->json([
            'data' => data_get(CategorizableContentPrivilegeCollection::from($privileges, $request->getLocale())->toArray(), 'data', []),
            'roles' => $roles->pluck('name')->toArray(),
        ]);
    }
}
