<?php

namespace Inside\Permission\Exodus\Enums;

use Inside\Host\Exodus\Enum\BaseExtendedEnum;
use Inside\Menu\Models\FooterMenuLink;
use Inside\Menu\Models\HeaderMenuLink;

/**
 * @todo PHP 8.2: use enum class and rewrite BaseExtendedEnum
 */
final class MenuEnum extends BaseExtendedEnum
{
    const HEADER = HeaderMenuLink::class;

    const FOOTER = FooterMenuLink::class;

    public static function label(string $type, string $langcode): string
    {
        return match ($type) {
            self::HEADER => match ($langcode) {
                'en' => 'Main menu',
                'es' => 'Menú principal',
                'de' => 'Hauptmenü',
                'nl' => 'Hoofdmenu',
                default => 'Menu principal',
            },
            self::FOOTER => match ($langcode) {
                'en' => 'Footer menu',
                'es' => 'Menú de pie de página',
                'de' => 'Fußzeilenmenü',
                'pt' => 'Menu de rodapé',
                'nl' => 'Voettekstmenu',
                default => 'Menu pied de page',
            },
            default => 'Unnamed menu'
        };
    }
}
