<?php

namespace Inside\Permission\Exodus\Enums;

use Illuminate\Support\Facades\Lang;
use Inside\Facades\Inside;
use Inside\Host\Exodus\Enum\BaseExtendedEnum;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;

/**
 * @todo PHP 8.2: use enum class and rewrite BaseExtendedEnum
 */
final class BackofficeEnum extends BaseExtendedEnum
{
    public static function extendedCases(): array
    {
        return Inside::getAllBackofficeEntries()
            ->map(fn (string $entry) => strtoupper($entry))
            ->mapWithKeys(fn (string $entry) => [$entry => $entry])
            ->toArray();
    }

    /**
     * Returns label for given backoffice section.
     *
     * @param string $value
     * @param string $locale
     * @return string
     */
    public static function label(string $value, string $locale): string
    {
        $key = str(BackofficePrivilege::TRANSLATION_PREFIX)->finish($value)->lower();

        return Lang::get($key->toString(), [], $locale);
    }
}
