<?php

namespace Inside\Permission\Exodus\Dto\Privileges;

use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Dto\Indexes\MenuIndexDto;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class MenuPrivilegeDto extends PrivilegeDtoImplementation
{
    private function __construct(
        public ?int $id,
        public ?MenuIndexDto $index,
        public CapabilityDto $capability,
    ) {
    }

    public static function from(?MenuIndexDto $index, CapabilityDto $capability, ?int $id = null): self
    {
        return new self($id, $index, $capability);
    }

    public static function fromModel(MenuPrivilege $model): self
    {
        $index = $model->index;

        return self::from(
            is_null($index) ? null : MenuIndexDto::fromModel($index),
            CapabilityDto::fromModel($model->capability),
            $model->id
        );
    }

    public function primaryKey(): string
    {
        return 'id';
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCapability(): CapabilityDto
    {
        return $this->capability;
    }

    public function getIndex(): ?MenuIndexDto
    {
        return $this->index;
    }

    public function toArray(): array
    {
        return [
            $this->primaryKey() => $this->id,
            'capability' => $this->capability->toArray(),
            'index' => $this->index?->toArray(),
        ];
    }
}
