<?php

namespace Inside\Permission\Exodus\Dto\Privileges;

use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class ContentTypePrivilegeDto extends PrivilegeDtoImplementation
{
    private function __construct(
        public ?int $id,
        public string $type,
        public CapabilityDto $capability,
    ) {
    }

    public static function from(string $type, CapabilityDto $capability, int $id = null): self
    {
        return new self($id, $type, $capability);
    }

    public static function fromModel(ContentTypePrivilege $model): self
    {
        return self::from(
            $model->type,
            CapabilityDto::fromModel($model->capability),
            $model->id,
        );
    }

    public function primaryKey(): string
    {
        return 'id';
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getCapability(): CapabilityDto
    {
        return $this->capability;
    }

    public function toArray(): array
    {
        return [
            $this->primaryKey() => $this->id,
            'type' => $this->type,
            'capability' => $this->capability->toArray(),
            'is_authorized' => $this->is_authorized,
        ];
    }
}
