<?php

namespace Inside\Permission\Exodus\Dto\Privileges;

use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Dto\Indexes\ContentTranslationIndexDto;
use Inside\Permission\Exodus\Dto\Indexes\PermissibleContentIndexDto;
use Inside\Permission\Exodus\Models\Privileges\CategorizableContentPrivilege;
use Inside\Permission\Exodus\Models\Privileges\ContentPrivilege;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentIndex;
use Inside\Permission\Exodus\Models\ViewModels\ContentTranslationIndexes;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class ContentPrivilegeDto extends PrivilegeDtoImplementation
{
    private function __construct(
        public ?int $id,
        public PermissibleContentIndexDto|ContentTranslationIndexDto|null $index,
        public CapabilityDto $capability,
    ) {
    }

    public static function from(PermissibleContentIndexDto|ContentTranslationIndexDto|null $index, CapabilityDto $capability, ?int $id = null): self
    {
        return new self($id, $index, $capability);
    }

    public static function fromModel(CategorizableContentPrivilege|ContentPrivilege $model): self
    {
        /** @var CategorizableContentIndex|ContentTranslationIndexes|null $index */
        $index = $model->index;

        $index = match (true) {
            $index instanceof CategorizableContentIndex => PermissibleContentIndexDto::fromModel($index),
            $index instanceof ContentTranslationIndexes => ContentTranslationIndexDto::fromModel($index),
            default => null,
        };

        return self::from(
            index: $index,
            capability: CapabilityDto::fromModel($model->capability),
            id: $model->id,
        );
    }

    public function primaryKey(): string
    {
        return 'id';
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIndex(): PermissibleContentIndexDto|ContentTranslationIndexDto|null
    {
        return $this->index;
    }

    public function getCapability(): CapabilityDto
    {
        return $this->capability;
    }

    public function toArray(): array
    {
        return [
            $this->primaryKey() => $this->id,
            'index' => $this->index?->toArray(),
            'capability' => $this->capability->toArray(),
            'is_authorized' => $this->is_authorized,
        ];
    }
}
