<?php

namespace Inside\Permission\Exodus\Dto\Privileges;

use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class BackofficePrivilegeDto extends PrivilegeDtoImplementation
{
    private function __construct(
        public ?int $id,
        public string $name,
        public CapabilityDto $capability,
    ) {
    }

    public static function from(string $name, CapabilityDto $capability, ?int $id = null): self
    {
        return new self($id, $name, $capability);
    }

    public static function fromModel(BackofficePrivilege $model): self
    {
        return self::from(
            $model->name,
            CapabilityDto::fromModel($model->capability),
            $model->id
        );
    }

    public function primaryKey(): string
    {
        return 'id';
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getCapability(): CapabilityDto
    {
        return $this->capability;
    }

    public function toArray(): array
    {
        return [
            $this->primaryKey() => $this->id,
            'name' => $this->name,
            'capability' => $this->capability->toArray(),
            'is_authorized' => $this->is_authorized,
        ];
    }
}
