<?php

namespace Inside\Permission\Exodus\Dto\Indexes;

use Inside\Permission\Exodus\Dto\BaseDtoImplementation;
use Inside\Permission\Exodus\Dto\ContentDto;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentTranslationIndexes;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class PermissibleContentTranslationIndexDto extends BaseDtoImplementation
{
    private function __construct(
        public string $uuid_host,
        public string $translatable_uuid,
        public string $translatable_type,
        public ?ContentDto $translatable,
    ) {
    }

    public static function from(string $uuid_host, string $translatable_uuid, string $translatable_type, ?ContentDto $translatable): self
    {
        return new self($uuid_host, $translatable_uuid, $translatable_type, $translatable);
    }

    public static function fromModel(CategorizableContentTranslationIndexes $model): self
    {
        return self::from(
            $model->uuid_host,
            $model->translatable_uuid,
            $model->translatable_type,
            $model->translatable ? ContentDto::fromModel($model->translatable) : null,
        );
    }

    public function primaryKey(): string
    {
        return 'uuid_host';
    }

    public function getUuidHost(): string
    {
        return $this->uuid_host;
    }

    public function getTranslatableUuid(): string
    {
        return $this->translatable_uuid;
    }

    public function getTranslatableType(): string
    {
        return $this->translatable_type;
    }

    public function getTranslatable(): ?ContentDto
    {
        return $this->translatable;
    }

    public function toArray(): array
    {
        return [
            'uuid' => $this->translatable_uuid,
            'type' => $this->translatable_type,
            'translatable' => $this->translatable?->toArray() ?? [],
        ];
    }
}
