<?php

namespace Inside\Permission\Exodus\Dto\Indexes;

use Inside\Permission\Exodus\Dto\BaseDtoImplementation;
use Inside\Permission\Exodus\Dto\MenuDto;
use Inside\Permission\Exodus\Models\ViewModels\MenuIndex;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class MenuIndexDto extends BaseDtoImplementation
{
    private function __construct(
        public string $uuid,
        public string $type,
        public ?MenuDto $menu,
    ) {
    }

    public static function from(string $uuid, string $type, ?MenuDto $menu = null): self
    {
        return new self($uuid, $type, $menu);
    }

    public static function fromModel(MenuIndex $model): self
    {
        return self::from(
            uuid: $model->uuid,
            type: $model->type,
            menu: MenuDto::fromModel($model->menu),
        );
    }

    public function primaryKey(): string
    {
        return 'uuid';
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return MenuDto|null
     */
    public function getMenu(): ?MenuDto
    {
        return $this->menu;
    }

    public function toArray(): array
    {
        return [
            $this->primaryKey() => $this->uuid,
            'type' => $this->type,
            'menu' => $this->menu?->toArray(),
        ];
    }
}
