<?php

namespace Inside\Permission\Exodus\Dto\Indexes;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Dto\BaseDtoImplementation;
use Inside\Permission\Exodus\Dto\ContentDto;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentTranslationIndexes;
use Inside\Permission\Exodus\Models\ViewModels\ContentTranslationIndexes;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class ContentTranslationIndexDto extends BaseDtoImplementation
{
    private function __construct(
        public string $uuid_host,
        public string $translatable_uuid,
        public string $translatable_type,
    ) {
    }

    public static function from(string $uuid_host, string $translatable_uuid, string $translatable_type): self
    {
        return new self($uuid_host, $translatable_uuid, $translatable_type);
    }

    public static function fromModel(ContentTranslationIndexes $model): self
    {
        return self::from(
            $model->uuid_host,
            $model->translatable_uuid,
            $model->translatable_type,
        );
    }

    public function primaryKey(): string
    {
        return 'uuid_host';
    }

    public function getUuidHost(): string
    {
        return $this->uuid_host;
    }

    public function getTranslatableUuid(): string
    {
        return $this->translatable_uuid;
    }

    public function getTranslatableType(): string
    {
        return $this->translatable_type;
    }

    public function getTranslations(): Collection
    {
        return collect();
    }

    public function getType(): string
    {
        return $this->translatable_type;
    }

    public function toArray(): array
    {
        return [
            'uuid' => $this->translatable_uuid,
            'type' => $this->translatable_type,
        ];
    }
}
