<?php

namespace Inside\Permission\Exodus\Dto;

use Inside\Content\Models\Content;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class ContentDto extends BaseDtoImplementation
{
    private function __construct(
        public string $title,
        public string $langcode,
        public string $link,
        public bool $status,
        public ?string $parent_uuid,
    ) {
    }

    public static function from(string $title, string $langcode, string $link, bool $status, ?string $parent_uuid = null): self
    {
        return new self($title, $langcode, $link, $status, $parent_uuid);
    }

    public static function fromModel(Content $model): self
    {
        return self::from(
            $model->title,
            $model->langcode,
            sprintf('edit/%s/%s', $model->content_type, $model->uuid),
            $model->status,
            $model->pid,
        );
    }

    public function primaryKey(): string
    {
        return 'uuid';
    }

    public function getParentUuid(): ?string
    {
        return $this->parent_uuid;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getLangcode(): string
    {
        return $this->langcode;
    }

    public function getStatus(): bool
    {
        return $this->status;
    }

    public function getLink(): string
    {
        return $this->link;
    }

    public function toArray(): array
    {
        return [
            'title' => $this->title,
            'parent_uuid' => $this->parent_uuid,
            'langcode' => $this->langcode,
            'status' => $this->status,
            'link' => $this->link,
        ];
    }
}
