<?php

namespace Inside\Permission\Exodus\Dto;

use Inside\Permission\Exodus\Models\Capability;

/**
 * @todo PHP8.2: use readonly properties, switch to public visibility and remove getters
 */
final class CapabilityDto extends BaseDtoImplementation
{
    private function __construct(private ?int $id, private string $name)
    {
    }

    public static function from(string $name, ?int $id = null): self
    {
        return new self($id, $name);
    }

    public static function fromModel(Capability $model): self
    {
        return self::from($model->name, $model->id);
    }

    public function primaryKey(): string
    {
        return 'id';
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function toArray(): array
    {
        return [
            $this->primaryKey() => $this->id,
            'name' => $this->name,
        ];
    }
}
