<?php

namespace Inside\Permission\Exodus\Contracts;

use Illuminate\Support\Collection;

interface AccessRestrictions
{
    /**
     * Get data that are not necessary because they are not present in expected data.
     *
     * @return Collection
     */
    public static function unnecessaries(): Collection;

    /**
     * Get data that are expected but possibly not present in available data.
     *
     * @return Collection
     */
    public static function expected(): Collection;

    /**
     * Get data that are available at this time but possibly not expected.
     *
     * @return Collection
     */
    public static function availables(): Collection;

    /**
     * Get data that are missing at this time but expected.
     *
     * @return Collection
     */
    public static function missing(): Collection;
}
