<?php

namespace Inside\Permission\Exodus\Actions\RemoveUnnecessaries;

use Inside\Permission\Exodus\Dto\Privileges\ContentTypePrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\ContentTypeAccessRestriction;

final class RemoveUnnecessaryContentTypePrivileges
{
    public function execute(): int
    {
        $unnecessaries = ContentTypeAccessRestriction::unnecessaries()->map(fn (ContentTypePrivilegeDto $dto) => $dto->getId())->values();

        ContentTypePrivilege::query()->whereIn('id', $unnecessaries->toArray())->delete();

        return $unnecessaries->count();
    }
}
