<?php

namespace Inside\Permission\Exodus\Actions\RemoveUnnecessaries;

use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\ContentPrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\ContentAccessRestriction;

final class RemoveUnnecessaryContentPrivileges
{
    public function execute(): int
    {
        $unnecessaries = ContentAccessRestriction::unnecessaries()->map(fn (ContentPrivilegeDto $dto) => $dto->getId())->values();

        ContentPrivilege::query()->whereIn('id', $unnecessaries->toArray())->delete();

        return $unnecessaries->count();
    }
}
