<?php

namespace Inside\Permission\Exodus\Actions\RemoveUnnecessaries;

use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\CategorizableContentPrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\CategorizableContentAccessRestriction;

final class RemoveUnnecessaryCategorizablePrivileges
{
    public function execute(): int
    {
        $unnecessaries = CategorizableContentAccessRestriction::unnecessaries()->map(fn (ContentPrivilegeDto $dto) => $dto->getId())->values();

        CategorizableContentPrivilege::query()->whereIn('id', $unnecessaries->toArray())->delete();

        return $unnecessaries->count();
    }
}
