<?php

namespace Inside\Permission\Exodus\Actions\RemoveDuplicateAuthenticatedPrivileges;

use Illuminate\Support\Facades\DB;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

final class RemoveDuplicateAuthenticatedPrivilegesMenu
{
    public function execute(): int
    {
        $authenticated_id = RolePrivilegesService::getAuthenticated()->id;
        $authenticated_privileges = RolePrivilegesService::getAuthenticatedMenuPrivilegesId();

        return DB::table(MenuPrivilege::PIVOT_ROLE_TABLE)
            ->where('role_id', '!=', $authenticated_id)
            ->whereIn('menu_privilege_id', $authenticated_privileges)
            ->delete();
    }
}
