<?php

namespace Inside\Permission\Exodus\Actions\RemoveDuplicateAuthenticatedPrivileges;

use Illuminate\Support\Facades\DB;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

final class RemoveDuplicateAuthenticatedPrivilegesBackofficeSections
{
    public function execute(): int
    {
        $authenticated_id = RolePrivilegesService::getAuthenticated()->id;
        $authenticated_privileges = RolePrivilegesService::getAuthenticatedBackofficePrivilegesId();

        return DB::table(BackofficePrivilege::PIVOT_ROLE_TABLE)
            ->where('role_id', '!=', $authenticated_id)
            ->whereIn('backoffice_section_id', $authenticated_privileges)
            ->delete();
    }
}
