<?php

namespace Inside\Permission\Exodus\Actions\PermissionLogic\User;

use Inside\Authentication\Models\User;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Exodus\Services\ContentTypeStatusService;
use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Enums\BackofficeEnum;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Services\RolePrivilegesService;
use Inside\Permission\Scopes\AllowedScope;

class CanUpdateContent
{
    public function handle(User $user, Content $content): bool
    {
        // Check if the user is super admin
        if ($user->isSuperAdmin()) {
            return true;
        }

        // If a user want to update his own information, he can.
        if ($content->is($user->information)) {
            return true;
        }

        // Users content is not permissible, the user must have backoffice access to create a user.
        if ($content instanceof Users) {
            return $user->hasBackofficeAccessTo('user');
        }

        // Check if the content type is permissible, if not, it's not possible to update the content.
        if (! $content::isPermissible()) {
            return false;
        }

        // Check if the user is the owner of the content.
        if ($content->isOwnedBy($user)) {
            return true;
        }

        // Check if at least one of the user's roles has the capability to update the content.
        return match ($content::isCategorizable()) {
            true => $user->getRolePrivilegesService()->canUpdateCategorizableContent($content),
            false => $user->getRolePrivilegesService()->canUpdateContent($content),
        };
    }
}
