<?php

namespace Inside\Permission\Exodus\Actions\GenerateMissing;

use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\CategorizableContentPrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\CategorizableContentAccessRestriction;

final class GenerateMissingCategorizablePrivileges
{
    public function execute(): int
    {
        $missing = CategorizableContentAccessRestriction::missing()->map(fn (ContentPrivilegeDto $dto) => [
            'capability_id' => $dto->getCapability()->getId(),
            'uuid_host' => $dto->getIndex()?->getUuidHost(),
        ]);

        CategorizableContentPrivilege::query()->insert($missing->toArray());

        return $missing->count();
    }
}
