<?php

namespace Inside\Permission\Exodus\Actions\GenerateMissing;

use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Services\AccessRestriction\CapabilityAccessRestriction;

final class GenerateMissingCapabilities
{
    public function execute(): int
    {
        $missing = CapabilityAccessRestriction::missing()->map(fn (CapabilityDto $dto) => [
            'name' => $dto->getName(),
        ]);

        Capability::query()->insert($missing->toArray());

        return $missing->count();
    }
}
