<?php

namespace Inside\Permission\Exodus\Actions\GenerateMissing;

use Inside\Permission\Exodus\Dto\Privileges\BackofficePrivilegeDto;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\BackofficeAccessRestriction;

final class GenerateMissingBackofficeSections
{
    public function execute(): int
    {
        $missing = BackofficeAccessRestriction::missing()->map(fn (BackofficePrivilegeDto $dto) => [
            'capability_id' => $dto->getCapability()->getId(),
            'name' => $dto->getName(),
        ]);

        BackofficePrivilege::query()->insert($missing->toArray());

        return $missing->count();
    }
}
