<?php

namespace Inside\Permission\Exodus\Actions\ConvertOldPermissions;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Inside\Host\Exodus\Services\ContentTypeStatusService;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Models\Privileges\ContentSpecificPrivilege;
use Inside\Permission\Exodus\Models\Role;

class ConvertOldBackofficePermissions
{
    public function execute(): void
    {
        $privileges = BackofficePrivilege::all();
        $roles = Role::where('name', 'not like', 'group-%')->get();

        Log::info('[Inside Permission] Converting old backoffice permissions');

        DB::table('inside_permissions')
            ->where('type', 'backoffice')
            ->whereIn('role_id', $roles->pluck('id'))
            ->get()
            ->map(function ($permission) use ($privileges) {
                $privilege = $privileges->firstWhere('name', str($permission->action)->after('access_')->upper())?->id;

                if (is_null($privilege)) {
                    Log::warning("[Inside Permission] Could not find privilege for {$permission->action} permission: role: {$permission->role_id}");

                    return false;
                }

                return [
                    'role_id' => $permission->role_id,
                    'access' => $privilege,
                ];
            })
            ->filter()
            ->groupBy('access')
            ->each(function ($roles, $access) use ($privileges) {
                Log::info("[Inside Permission] Syncing roles [{$roles->pluck('role_id')->implode(', ')}] to privilege {$access}");

                $privileges->firstWhere('id', $access)->roles()->sync($roles->pluck('role_id'));
            });
    }
}
