<?php

namespace Inside\Permission\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Support\Collection;
use Inside\Events\Dispatchable;

class BackofficeEntriesPermissionChangedEvents implements ShouldBroadcast
{
    use Dispatchable;

    public function __construct(
        public int $roleId,
        public Collection $backofficeEntries
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside_permission.backoffice_entries.'.$this->roleId);
    }

    /**
     * @return Collection[]
     */
    public function broadcastWith(): array
    {
        return [
            'backoffice_entries' => $this->backofficeEntries,
        ];
    }

    /**
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'inside_permission.backoffice_entries.changed';
    }
}
