<?php

namespace Inside\Permission\Console;

use Illuminate\Console\Command;
use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Services\ComputeRestriction\ComputeRestrictionService;
use Inside\Permission\Exodus\Services\RolePrivilegesService;
use Inside\Permission\Facades\Permission;

/**
 * Rebuild dynamic model command.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class PermissionsV2RebuildCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'permissions:V2:rebuild';

    /**
     * @var string
     */
    protected $description = 'Rebuild content permissions for each role';

    /**
     * @throws \Exception
     */
    public function handle(): void
    {
        $contentTypes = ComputeRestrictionService::getPermissibleButNotCategorizableContentTypes();

        foreach ($contentTypes as $contentType) {
            $this->info("Rebuilding permissions for content type: {$contentType}");

            $contents = $contentType::all();

            for ($i = 0; $i < count($contents); $i++) {
                /** @var Content $content */
                $content = $contents[$i];

                $this->info("[{$i}/".count($contents)."] Processing content UUID: {$content->uuid} - {$content->title}");

                ComputeRestrictionService::computeCapabilitiesOnContentForRoles($content);
            }
        }

        RolePrivilegesService::clearAllCache();
    }
}
