<?php

namespace Inside\Permission\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Inside\Permission\Facades\Permission;
use Inside\Permission\Services\PermissionService;

/**
 * Rebuild dynamic model command.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class PermissionsV2MigrateCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'permissions:V2:migrate';

    /**
     * @var string
     */
    protected $description = 'Definitively migrate the system v2';

    /**
     * @throws \Exception
     */
    public function handle(): void
    {
        if (! PermissionService::isSystemV2Initialized()) {
            $this->error('You have to initialize the system v2 before migrating it.');

            return;
        }

        if (PermissionService::isSystemV2Migrated()) {
            $this->error('You have already definitively migrated the system v2.');

            return;
        }

        setting('permission', ['system_v2_migrated' => true]);

        $this->info('Definitively migrating system v2.');
    }
}
