<?php

namespace Inside\Permission\Console;

use Illuminate\Console\Command;
use Inside\Permission\Facades\Permission;

/**
 * Rebuild dynamic model command.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class PermissionsRebuildCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'permissions:rebuild';

    /**
     * @var string
     */
    protected $description = 'Rebuild permissions';

    /**
     * @throws \Exception
     */
    public function handle(): void
    {
        Permission::buildPermissionForAllRoles();

        $this->info('Permissions have been regenerated');
    }
}
