<?php

namespace Inside\Permission\Seeders;

use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Permission\Models\Role;

class AuthenticatedSeeder extends Seeder
{
    public function run(): void
    {
        $role = Role::firstOrCreate(['name' => 'authenticated']);

        User::all()->each(
            function ($user) use ($role) {
                $user->assignRole($role);
            }
        );
    }
}
