<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Log;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Services\RolePrivilegesService;
use Inside\Permission\Services\PermissionService;

class ComputeRestrictionAllRoles extends Migration
{
    public function up() : void
    {
        if (! PermissionService::isSystemV2Initialized()) {
            return;
        }

        Role::withoutDeprecatedRoles()->withoutSuperAdministrator()->each(function (Role $role) {
            Log::info("[Inside Permission] Computing restriction for role {$role->id} ({$role->name})");
            $role->computeRestriction();
        });
    }
}
